<?php

/**
 * messages
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch bootloader
require('bootloader.php');

// user access
user_access();

// page header
page_header(__("Messages"));

// check user chat privacy
if ($user->_data['user_privacy_chat'] == "me") {
  _error('CHAT_PERMISSION');
}

try {

  // check the view
  $view = (!isset($_GET['view'])) ? 'message' : 'new';

  // get view content
  if ($view == 'message') {

    if (!isset($_GET['cid'])) {
      $sub_view = 'all';
      if ($user->_data['conversations']) {
        $conversation = $user->_data['conversations'][0];
        $conversation['messages'] = $user->get_conversation_messages($conversation['conversation_id'])['messages'];
      }
    } else {
      $sub_view = 'conversation';
      /* check cid is valid */
      if (is_empty($_GET['cid']) || !is_numeric($_GET['cid'])) {
        _error(404);
      }
      $conversation = $user->get_conversation($_GET['cid']);
      $conversation['messages'] = $user->get_conversation_messages($conversation['conversation_id'])['messages'];
    }
    // assign variables
    $smarty->assign('sub_view', $sub_view);
    $smarty->assign('conversation', $conversation);
  } elseif ($view == 'new') {

    /* get recipient */
    if (isset($_GET['uid'])) {
      $get_recipient = $db->query(sprintf("SELECT user_id, user_name, CONCAT(users.user_firstname,' ',users.user_lastname) as user_fullname FROM users WHERE user_id = %s", secure($_GET['uid'], 'int')));
      if ($get_recipient->num_rows > 0) {
        $recipient = $get_recipient->fetch_assoc();
        $recipient["user_fullname"] = ($system['show_usernames_enabled']) ? $recipient['user_name'] : $recipient['user_fullname'];
        /* assign variables */
        $smarty->assign('recipient', $recipient);
      }
    }
  }
  /* assign variables */
  $smarty->assign('view', $view);
} catch (Exception $e) {
  _error(__("Error"), $e->getMessage());
}

// page footer
page_footer('messages');
